import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Hashtable;
import java.util.List;
import java.util.LinkedList;
import codeassess.javassessment.Assessor;
import codeassess.misc.Misc;

public class Template extends Assessor {

    public Map<String, String> getConfig() {
        final Map<String, String> config = new Hashtable<String, String>();
        config.put("Language", "Java");
        config.put("Extensions", ".java");
        config.put("AssessmentMode", "SemiAutomatic");
        return config;
    }

    public List<Object[]> getProperties() {
        final List<Object[]> properties = new LinkedList<Object[]>();
        properties.add(new Object[] { "Eval1", "Functionality", "Metodos.java", "Debes implementar el método factorial", "Implementar el método factorial", 0.0 });
        properties.add(new Object[] { "Eval5", "Functionality", "Metodos.java", "Debes implementar el método factoriall", "El método factorial existe y devuelve el tipo correcto", 1.0 });
        properties.add(new Object[] { "Eval6", "Functionality", "Metodos.java", "El método debe recibir un entero", "Los parametros de factorial son correctos", 1.0 });
        properties.add(new Object[] { "Eval7", "Functionality", "Metodos.java", "Debes implementar un caso base", "Implementar caso base de factorial", 3.0 });
        properties.add(new Object[] { "Eval8", "Functionality", "Metodos.java", "Debes implementar el caso recursivo", "Implementar caso recursivo de factorial", 5.0 });
        properties.add(new Object[] { "Eval2", "Functionality", "Metodos.java", "Debes implementar el método fibonacci", "Implementar el método fibonacci", 0.0 });
        properties.add(new Object[] { "Eval9", "Functionality", "Metodos.java", "Debes implementar el método fibonacci", "El método fibonacci existe y devuelve el tipo correcto", 1.0 });
        properties.add(new Object[] { "Eval10", "Functionality", "Metodos.java", "El método debe recibir un entero", "Los parametros de fibonacci son correctos", 1.0 });
        properties.add(new Object[] { "Eval11", "Functionality", "Metodos.java", "Debes implementar un caso base", "Implementar caso base de fibonacci", 3.0 });
        properties.add(new Object[] { "Eval12", "Functionality", "Metodos.java", "Debes implementar un caso recursivo", "Implementar caso recursivo de fibonacci", 5.0 });
        properties.add(new Object[] { "Eval3", "Functionality", "Metodos.java", "Debes implementar el método suma cuadrados", "Implementar el método suma cuadrados", 0.0 });
        properties.add(new Object[] { "Eval13", "Functionality", "Metodos.java", "Debes implementar el método suma cuadrados", "El método suma cuadrados existe y devuelve el tipo correcto", 1.0 });
        properties.add(new Object[] { "Eval14", "Functionality", "Metodos.java", "El método debe recibir un array de enteros", "Los parametros de suma cuadrados son correctos", 1.0 });
        properties.add(new Object[] { "Eval15", "Functionality", "Metodos.java", "Debes implementar un caso base", "Implementar caso base de suma cuadrados", 3.0 });
        properties.add(new Object[] { "Eval16", "Functionality", "Metodos.java", "Debes implementar un caso recursivo", "Implementar caso recursivo de suma cuadrados", 5.0 });
        properties.add(new Object[] { "Eval4", "Functionality", "Metodos-.java", "Debes implementar el método nPrimes", "Implementar el método nPrimes", 0.0 });
        properties.add(new Object[] { "Eval17", "Functionality", "Metodos.java", "Debes implementar el método nPrimes", "El método nPrimes existe y devuelve el tipo correcto", 1.0 });
        properties.add(new Object[] { "Eval18", "Functionality", "Metodos.java", "El método debe recibir un entero", "Los parametros de nPrimes son correctos", 1.0 });
        properties.add(new Object[] { "Eval19", "Functionality", "Metodos.java", "Debes implementar un caso base", "Implementar caso base de nPrimes", 3.0 });
        properties.add(new Object[] { "Eval20", "Functionality", "Metodos.java", "Debes implementar un caso recursivo", "Implementar caso recursivo de nPrimes", 5.0 });
        return properties;
    }

    public boolean checkEval1() {
        return true;
    }

    public boolean solveEval1() {
        return false;
    }

    public boolean testEval1() {
        return true;
    }

    public boolean checkEval5() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        boolean method1Checker = false;
        for (Method method1 : super.introspector.getDeclaredMethods(class1)) {
            if (!(super.introspector.getName(method1).equals("factorial"))) continue;
            final Class class2 = super.introspector.getReturnClass(method1);
            if (class2 == null) continue;
            if (!(super.introspector.checkSameClasses(class2, long.class, true) == true)) continue;
            method1Checker = true;
            break;
        }
        if (method1Checker == false) return false;
        return true;
    }

    public boolean solveEval5() {
        return false;
    }

    public boolean testEval5() {
        return true;
    }

    public boolean checkEval6() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        final Class[] classs1 = { int.class };
        if (!(super.introspector.checkDeclaredMethod(class1, "factorial", classs1, true) == true)) return false;
        return true;
    }

    public boolean solveEval6() {
        return false;
    }

    public boolean testEval6() {
        return true;
    }

    public boolean checkEval7() {
        return true;
    }

    public boolean solveEval7() {
        return false;
    }

    public boolean testEval7() {
        if (!(super.tester.executeTestCase("ManualTestCases2", "test1").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test2").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test3").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test4").equals(true))) return false;
        return true;
    }

    public boolean checkEval8() {
        return true;
    }

    public boolean solveEval8() {
        return false;
    }

    public boolean testEval8() {
        if (!(super.tester.executeTestCases("AutomaticTestCases2") >= 90)) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test10").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test11").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test12").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test13").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test14").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases2", "test15").equals(true))) return false;
        return true;
    }

    public boolean checkEval2() {
        return true;
    }

    public boolean solveEval2() {
        return false;
    }

    public boolean testEval2() {
        return true;
    }

    public boolean checkEval9() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        boolean method1Checker = false;
        for (Method method1 : super.introspector.getDeclaredMethods(class1)) {
            if (!(super.introspector.getName(method1).equals("fibonacci"))) continue;
            final Class class2 = super.introspector.getReturnClass(method1);
            if (class2 == null) continue;
            if (!(super.introspector.checkSameClasses(class2, int.class, true) == true)) continue;
            method1Checker = true;
            break;
        }
        if (method1Checker == false) return false;
        return true;
    }

    public boolean solveEval9() {
        return false;
    }

    public boolean testEval9() {
        return true;
    }

    public boolean checkEval10() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        final Class[] classs1 = { int.class };
        if (!(super.introspector.checkDeclaredMethod(class1, "fibonacci", classs1, true) == true)) return false;
        return true;
    }

    public boolean solveEval10() {
        return false;
    }

    public boolean testEval10() {
        return true;
    }

    public boolean checkEval11() {
        return true;
    }

    public boolean solveEval11() {
        return false;
    }

    public boolean testEval11() {
        if (!(super.tester.executeTestCase("ManualTestCases1", "test1").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test2").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test3").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test4").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test5").equals(true))) return false;
        return true;
    }

    public boolean checkEval12() {
        return true;
    }

    public boolean solveEval12() {
        return false;
    }

    public boolean testEval12() {
        if (!(super.tester.executeTestCases("AutomaticTestCases1") >= 90)) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test10").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test11").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test12").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test13").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test14").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test15").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test16").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test17").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases1", "test18").equals(true))) return false;
        return true;
    }

    public boolean checkEval3() {
        return true;
    }

    public boolean solveEval3() {
        return false;
    }

    public boolean testEval3() {
        return true;
    }

    public boolean checkEval13() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        boolean method1Checker = false;
        for (Method method1 : super.introspector.getDeclaredMethods(class1)) {
            if (!(super.introspector.getName(method1).equals("sumaCuadrados"))) continue;
            final Class class2 = super.introspector.getReturnClass(method1);
            if (class2 == null) continue;
            if (!(super.introspector.checkSameClasses(class2, int.class, true) == true)) continue;
            method1Checker = true;
            break;
        }
        if (method1Checker == false) return false;
        return true;
    }

    public boolean solveEval13() {
        return false;
    }

    public boolean testEval13() {
        return true;
    }

    public boolean checkEval14() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        final Class class2 = int[].class;
        if (class2 == null) return false;
        final Class[] classs1 = { class2 };
        if (!(super.introspector.checkDeclaredMethod(class1, "sumaCuadrados", classs1, true) == true)) return false;
        return true;
    }

    public boolean solveEval14() {
        return false;
    }

    public boolean testEval14() {
        return true;
    }

    public boolean checkEval15() {
        return true;
    }

    public boolean solveEval15() {
        return false;
    }

    public boolean testEval15() {
        return true;
    }

    public boolean checkEval16() {
        return true;
    }

    public boolean solveEval16() {
        return false;
    }

    public boolean testEval16() {
        return true;
    }

    public boolean checkEval4() {
        return true;
    }

    public boolean solveEval4() {
        return false;
    }

    public boolean testEval4() {
        return true;
    }

    public boolean checkEval17() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        boolean method1Checker = false;
        for (Method method1 : super.introspector.getDeclaredMethods(class1)) {
            if (!(super.introspector.getName(method1).equals("nPrimes"))) continue;
            final Class class2 = super.introspector.getReturnClass(method1);
            if (class2 == null) continue;
            if (!(super.introspector.checkSameClasses(class2, int.class, true) == true)) continue;
            method1Checker = true;
            break;
        }
        if (method1Checker == false) return false;
        return true;
    }

    public boolean solveEval17() {
        return false;
    }

    public boolean testEval17() {
        return true;
    }

    public boolean checkEval18() {
        final Class class1 = super.introspector.getClass("Metodos");
        if (class1 == null) return false;
        final Class[] classs1 = { int.class };
        if (!(super.introspector.checkDeclaredMethod(class1, "nPrimes", classs1, true) == true)) return false;
        return true;
    }

    public boolean solveEval18() {
        return false;
    }

    public boolean testEval18() {
        return true;
    }

    public boolean checkEval19() {
        return true;
    }

    public boolean solveEval19() {
        return false;
    }

    public boolean testEval19() {
        if (!(super.tester.executeTestCase("ManualTestCases3", "test1").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test2").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test3").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test4").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test5").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test6").equals(true))) return false;
        return true;
    }

    public boolean checkEval20() {
        return true;
    }

    public boolean solveEval20() {
        return false;
    }

    public boolean testEval20() {
        if (!(super.tester.executeTestCases("AutomaticTestCases3") >= 90)) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test10").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test11").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test12").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test13").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test14").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test15").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test16").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test17").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test18").equals(true))) return false;
        if (!(super.tester.executeTestCase("ManualTestCases3", "test19").equals(true))) return false;
        return true;
    }
}
